/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import org.apache.log4j.Logger;

public class ModificationAttributObjet {
    private static Logger log = Logger.getLogger(ModificationAttributObjet.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l, long l2, String string, String string2) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                Resultat resultat = null;
                if (string2 != null) {
                    resultat = new Resultat("Modification de l'attribut CKA_VALUE de l'objet \"" + string + "\" (C_SetAttributeValue)");
                    CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
                    cK_ATTRIBUTEArray[0].type = 17L;
                    cK_ATTRIBUTEArray[0].pValue = TraitementsUtil.getOctetsSansFormatage(string2);
                    try {
                        pKCS11.C_SetAttributeValue(l, l2, cK_ATTRIBUTEArray);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                        resultat.setCodeRetour(pKCS11Exception.getErrorCode());
                    }
                } else {
                    log.error((Object)"Les donn\u00e9es applicatives sont nulles");
                    throw new ExceptionTraitement(24, "Les donn\u00e9es applicatives sont nulles");
                }
                return resultat;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(24, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(24, "Une erreur inattendue est survenue");
        }
    }
}

